/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.styles;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.styles.StyleWrapper;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.plaf.basic.BasicTabbedPaneUI;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthStyle;

public class TabbedPaneStyle
extends StyleWrapper {
    private static TabbedPaneStyle instance = new TabbedPaneStyle();

    private TabbedPaneStyle() {
    }

    public static SynthStyle getStyle(SynthStyle synthStyle, JComponent jComponent, Region region) {
        if (SyntheticaLookAndFeel.getJVMCompatibilityMode() == SyntheticaLookAndFeel.JVMCompatibilityMode.SUN) {
            TabbedPaneStyle.installTabLayoutManager((JTabbedPane)jComponent);
        }
        if (SyntheticaLookAndFeel.getStyleName(jComponent) == null) {
            instance.setStyle(synthStyle);
            return instance;
        }
        TabbedPaneStyle tabbedPaneStyle = new TabbedPaneStyle();
        tabbedPaneStyle.setStyle(synthStyle);
        return tabbedPaneStyle;
    }

    public Font getFont(SynthContext synthContext) {
        if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tab.selected.bold", synthContext.getComponent())) {
            return this.synthStyle.getFont(synthContext).deriveFont(1);
        }
        return this.synthStyle.getFont(synthContext);
    }

    private static void installTabLayoutManager(JTabbedPane jTabbedPane) {
        if (jTabbedPane.getLayout().getClass().getName().contains(TabbedPaneStyle.class.getName())) {
            return;
        }
        if (!SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tabs.stretch", jTabbedPane) && (SyntheticaLookAndFeel.get("Synthetica.tabbedPane.rotateTabRuns", jTabbedPane) == null || SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.rotateTabRuns", jTabbedPane))) {
            return;
        }
        if (jTabbedPane.getTabLayoutPolicy() == 1) {
            TabbedPaneStyle.installScrollLayout(jTabbedPane);
        } else {
            TabbedPaneStyle.installWrapLayout(jTabbedPane);
        }
    }

    private static void installWrapLayout(final JTabbedPane jTabbedPane) {
        BasicTabbedPaneUI basicTabbedPaneUI;
        BasicTabbedPaneUI basicTabbedPaneUI2 = basicTabbedPaneUI = (BasicTabbedPaneUI)jTabbedPane.getUI();
        basicTabbedPaneUI2.getClass();
        jTabbedPane.setLayout(new BasicTabbedPaneUI.TabbedPaneLayout(basicTabbedPaneUI2){

            protected void calculateTabRects(int n2, int n3) {
                super.calculateTabRects(n2, n3);
                if (SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.tabs.stretch", jTabbedPane) && n3 > 0) {
                    Object object;
                    Serializable serializable;
                    Rectangle[] rectangleArray = null;
                    try {
                        serializable = Class.forName("javax.swing.plaf.basic.BasicTabbedPaneUI");
                        object = serializable.getDeclaredField("rects");
                        ((Field)object).setAccessible(true);
                        rectangleArray = (Rectangle[])((Field)object).get(basicTabbedPaneUI);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                    serializable = jTabbedPane.getInsets();
                    object = new Insets(0, 0, 0, 0);
                    try {
                        Class<?> clazz = Class.forName("javax.swing.plaf.basic.BasicTabbedPaneUI");
                        Method method = clazz.getDeclaredMethod("getTabAreaInsets", Integer.TYPE);
                        method.setAccessible(true);
                        object = (Insets)method.invoke((Object)basicTabbedPaneUI, n2);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception);
                    }
                    int n4 = jTabbedPane.getWidth() - (((Insets)serializable).right + ((Insets)object).right + ((Insets)serializable).left + ((Insets)object).left);
                    int n5 = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tabs.maxStretchFactor", jTabbedPane, 3);
                    int n6 = 0;
                    int n7 = n3 - 1;
                    Rectangle rectangle = rectangleArray[n7];
                    int n8 = rectangle.x + rectangle.width - rectangleArray[n6].x;
                    if (n8 >= n4 || n8 < 1) {
                        return;
                    }
                    boolean bl = n4 / n8 > n5;
                    jTabbedPane.putClientProperty("Synthetica.maxStretchExceeded", bl);
                    int n9 = SyntheticaLookAndFeel.getInt("Synthetica.tabbedPane.tabs.centeredTabsFactor", jTabbedPane, n5);
                    int n10 = bl ? n8 * n9 : n4;
                    int n11 = n10 - (rectangle.x + rectangle.width) + ((Insets)serializable).left + ((Insets)object).left;
                    int n12 = (n4 - n10) / 2;
                    float f2 = (float)n11 / (float)n8;
                    int n13 = n6;
                    while (n13 <= n7) {
                        Rectangle rectangle2 = rectangleArray[n13];
                        rectangle2.x = n13 == n6 ? (rectangle2.x += n12) : rectangleArray[n13 - 1].x + rectangleArray[n13 - 1].width;
                        rectangle2.width += Math.round((float)rectangle2.width * f2);
                        ++n13;
                    }
                }
            }

            protected void rotateTabRuns(int n2, int n3) {
                if (SyntheticaLookAndFeel.get("Synthetica.tabbedPane.rotateTabRuns", jTabbedPane) == null || SyntheticaLookAndFeel.getBoolean("Synthetica.tabbedPane.rotateTabRuns", jTabbedPane)) {
                    super.rotateTabRuns(n2, n3);
                }
            }
        });
    }

    private static void installScrollLayout(JTabbedPane jTabbedPane) {
    }
}

